/*
 * Decompiled with CFR 0.152.
 */
package bird.comm;

import bird.comm.CommExc;
import bird.comm.CommInt;
import bird.comm.TCPIPDataInputStream;
import bird.comm.TCPIPDataOutputStream;
import bird.util.CircBuf;
import bird.util.Dbg;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;

public class TCPIPCommInt
implements CommInt,
Runnable {
    private InetAddress hostIP_;
    private int hostPort_;
    private Socket clientSocket_;
    private TCPIPDataInputStream dis_;
    private TCPIPDataOutputStream dos_;
    private boolean isOpen_;
    private Thread tcpipListenerTh_;
    private boolean mustStop_;
    private CircBuf inBuf_;
    private int recvBufSize_;
    private boolean isIOPending_;

    public TCPIPCommInt(InetAddress inetAddress, int n, int n2) {
        this.hostIP_ = inetAddress;
        this.hostPort_ = n;
        this.clientSocket_ = null;
        this.dis_ = null;
        this.dos_ = null;
        this.isOpen_ = false;
        this.isIOPending_ = false;
        this.mustStop_ = true;
        this.inBuf_ = new CircBuf(n2);
        this.tcpipListenerTh_ = new Thread((Runnable)this, "TCPIPComm");
    }

    public synchronized void open() throws CommExc {
        if (this.isOpen_) {
            throw new CommExc("TCPIP aleady open!");
        }
        try {
            this.clientSocket_ = new Socket(this.hostIP_, this.hostPort_);
            this.createDataStreams(this.clientSocket_);
        }
        catch (Exception exception) {
            try {
                this.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new CommExc("Cannot open socket (" + this.hostIP_.toString() + ":" + this.hostPort_ + ")", exception);
        }
        this.isOpen_ = true;
        this.isIOPending_ = false;
        this.inBuf_.clear(true, 0);
        this.setMustStop(false);
        this.tcpipListenerTh_.start();
    }

    public synchronized void close() {
        this.isIOPending_ = false;
        if (this.isOpen_) {
            this.isOpen_ = false;
            try {
                this.inBuf_.clear(true, 0);
                if (this.tcpipListenerTh_.isAlive()) {
                    this.setMustStop(true);
                    this.wakeupTh();
                    this.tcpipListenerTh_.join(1000L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.clientSocket_ != null) {
                this.clientSocket_.close();
                this.clientSocket_ = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dis_ != null) {
                this.dis_.close();
                this.dis_ = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.dos_ != null) {
                this.dos_.close();
                this.dos_ = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void purge() {
        this.inBuf_.clear(true, 0);
    }

    public synchronized int send(byte[] byArray, int n, int n2) throws CommExc {
        if (!this.isOpen_) {
            throw new CommExc("Not Open!");
        }
        this.isIOPending_ = true;
        int n3 = 0;
        try {
            this.dos_.write(byArray, 0, n);
            this.dos_.flush();
            n3 = n;
            this.isIOPending_ = false;
            Thread.yield();
        }
        catch (Exception exception) {
            this.isIOPending_ = false;
            throw new CommExc(exception);
        }
        return n3;
    }

    public synchronized int receive(byte[] byArray, int n, int n2) throws CommExc {
        if (!this.isOpen_) {
            throw new CommExc("Not Open!");
        }
        long l = System.currentTimeMillis() + (long)n2;
        while (this.inBuf_.getLength() < n && System.currentTimeMillis() <= l) {
            Thread.yield();
        }
        return this.inBuf_.getElements(byArray, n);
    }

    public synchronized int receiveAvail(byte[] byArray) throws CommExc {
        if (!this.isOpen_) {
            throw new CommExc("Not Open!");
        }
        if (byArray == null) {
            return 0;
        }
        return this.inBuf_.getElements(byArray, Math.min(byArray.length, this.inBuf_.getLength()));
    }

    public synchronized byte[] receiveUntilDelim(byte by, int n) throws CommExc {
        if (!this.isOpen_) {
            throw new CommExc("Not Open!");
        }
        byte[] byArray = null;
        long l = System.currentTimeMillis() + (long)n;
        while (true) {
            int n2;
            if ((n2 = this.inBuf_.findElement(by)) != -1) {
                byArray = new byte[n2 + 1];
                Arrays.fill(byArray, (byte)0);
                this.inBuf_.getElements(byArray, n2 + 1);
                break;
            }
            if (System.currentTimeMillis() > l) break;
            Thread.yield();
        }
        return byArray;
    }

    public int numBytesAvail() {
        return this.inBuf_.getLength();
    }

    public boolean isOpen() {
        return this.isOpen_;
    }

    public boolean isIOPending() {
        return this.isIOPending_;
    }

    public void run() {
        Dbg.getInst().log("Started.", Dbg.LVL_SYS);
        byte[] byArray = new byte[this.inBuf_.getSize()];
        int n = 0;
        int n2 = 0;
        while (!this.getMustStop()) {
            try {
                Arrays.fill(byArray, (byte)0);
                n = this.dis_.read(byArray, 0, 1);
                this.inBuf_.addElements(byArray, n);
                n2 = Math.min(this.dis_.available(), byArray.length);
                if (n2 <= 0 || (n = this.dis_.read(byArray, 0, n2)) <= 0) continue;
                this.inBuf_.addElements(byArray, n);
            }
            catch (Exception exception) {
                Thread.yield();
            }
        }
        Dbg.getInst().log("Stopped gracefully.", Dbg.LVL_SYS);
    }

    protected void createDataStreams(Socket socket) throws IOException {
        this.dis_ = new TCPIPDataInputStream(socket);
        this.dos_ = new TCPIPDataOutputStream(socket);
    }

    protected void setDataInputStream(TCPIPDataInputStream tCPIPDataInputStream) {
        this.dis_ = tCPIPDataInputStream;
    }

    protected void setDataOutputStream(TCPIPDataOutputStream tCPIPDataOutputStream) {
        this.dos_ = tCPIPDataOutputStream;
    }

    protected TCPIPDataInputStream getDataInputStream() {
        return this.dis_;
    }

    protected TCPIPDataOutputStream getDataOutputStream() {
        return this.dos_;
    }

    private synchronized void setMustStop(boolean bl) {
        this.mustStop_ = bl;
    }

    private boolean getMustStop() {
        return this.mustStop_;
    }

    private synchronized void wakeupTh() {
        try {
            this.tcpipListenerTh_.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.yield();
    }
}

